void main() {
    final int anz = 50_000, len = 20, wdh = 500;
    final var sb = new StringBuilder();
    final var ran = new Random();
    final var sar = new String[anz];

    // Zufallszeichenfolgen mithilfe eines StringBuilder-Objekts erzeugen
    for (int i = 0; i < anz; i++) {
        for (int j = 0; j < len; j++)
            sb.append((char) (65 + ran.nextInt(26)));
        sar[i] = sb.toString();
        sb.delete(0, len);
    }

    // Warmlaufen
    long start = System.currentTimeMillis();
    int hits = 0;
    for (int n = 1; n <= wdh; n++)
        for (int i = 0; i < anz; i++)
            if (sar[i].equals(sar[ran.nextInt(anz)]))
                hits++;
    IO.println((wdh * anz) + " Inhaltsvergleiche (" + hits +
            " hits) benötigen beim Warmlaufen " + (System.currentTimeMillis() - start) + " Millisekunden");
    // Inhaltsvergleiche
    start = System.currentTimeMillis();
    hits = 0;
    for (int n = 1; n <= wdh; n++)
        for (int i = 0; i < anz; i++)
            if (sar[i].equals(sar[ran.nextInt(anz)]))
                hits++;
    IO.println((wdh * anz) + " Inhaltsvergleiche (" + hits +
            " hits) benötigen " + (System.currentTimeMillis() - start) + " Millisekunden");

    // Internieren
    start = System.currentTimeMillis();
    for (int j = 1; j < anz; j++)
        sar[j] = sar[j].intern();
    IO.println("\nZeit für das Internieren: " +
            (System.currentTimeMillis() - start) + " Millisekunden");

    // Adressvergleiche
    start = System.currentTimeMillis();
    hits = 0;
    for (int n = 1; n <= wdh; n++)
        for (int i = 0; i < anz; i++)
            if (sar[i] == sar[ran.nextInt(anz)])
                hits++;
    IO.println((wdh * anz) + " Adressvergleiche (" + hits +
            " hits) benötigen (inkl. Internieren) " + (System.currentTimeMillis() - start) + " Millisekunden");
}
